--[[--------------------------------------------------------------------
	!ClassColors
	Change class colors without breaking the Blizzard UI.
	Copyright (c) 2009-2016 Phanx <addons@phanx.net>. All rights reserved.
	http://www.wowinterface.com/downloads/info12513-ClassColors.html
	http://www.curse.com/addons/wow/classcolors
----------------------------------------------------------------------]]

local ADDON, ns = ...
local L = {}
ns.L = L

L.TITLE = GetAddOnMetadata(ADDON, "Title")
L.NOTES = GetAddOnMetadata(ADDON, "Notes")

FillLocalizedClassList(L, false)

setmetatable(L, { __index = function(t, k)
	local v = tostring(k)
	t[k] = v
	return v
end })

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED. SEE:
-- http://wow.curseforge.com/addons/classcolors/localization/

------------------------------------------------------------------------
-- English
------------------------------------------------------------------------

L.NOTES = "Change class colors without breaking the Blizzard UI."
L.NOTES_DESC = "Note that not all addons support this, and you may need to reload the UI before your changes are recognized by all compatible addons."
L.RESET_DESC = "Reset all class colors to their Blizzard defaults."

local CURRENT_LOCALE = GetLocale()
if CURRENT_LOCALE == "enUS" then return end

------------------------------------------------------------------------
-- German
------------------------------------------------------------------------

if CURRENT_LOCALE == "deDE" then

L.NOTES = "Klassenfarben ändern, ohne die Blizzard-UI zu zerbrechen."
L.NOTES_DESC = "Beachten Sie, dass nicht alle Addons unterstützt dieses System, und Sie müssen möglicherweise die UI neuladen, um die Änderungen auf alle kompatiblen Addons zu übernehmen."
L.RESET_DESC = "Die Klassenfarben auf die Standardverte zurücksetzen."

return end

------------------------------------------------------------------------
-- Spanish
------------------------------------------------------------------------

if CURRENT_LOCALE == "esES" then

L.NOTES = "Cambiar los colores de clase sin romper la interfaz de usario de Blizzard."
L.NOTES_DESC = "Note que no todos los addons aprobar este, y es posible que tengas a volver a cargar la interfaz para que los cambios ser reconocidos por todos addons compatibles."
L.RESET_DESC = "Restaurar los colores de las clases por el defecto."

return end

------------------------------------------------------------------------
-- Latin American Spanish
------------------------------------------------------------------------

if CURRENT_LOCALE == "esMX" then

L.NOTES = "Cambiar los colores de clase sin romper la interfaz de usario de Blizzard."
L.NOTES_DESC = "Note que no todos los addons aprobar este, y es posible que tengas a volver a cargar la interfaz para que los cambios ser reconocidos por todos addons compatibles."
L.RESET_DESC = "Restaurar los colores de las clases por el defecto."

return end

------------------------------------------------------------------------
-- French
------------------------------------------------------------------------

if CURRENT_LOCALE == "frFR" then

L.NOTES = "Modifier les couleurs de classe sans casser l'interface Blizzard."
L.RESET_DESC = "Réinitialisez les couleurs des classes par défaut."

return end

------------------------------------------------------------------------
-- Italian
------------------------------------------------------------------------

if CURRENT_LOCALE == "itIT" then

L.NOTES = "Modificare i colori di classe senza rompere l'interfaccia utente Blizzard."
L.RESET_DESC = "Ripristina i colori delle classi di default."

return end

------------------------------------------------------------------------
-- Brazilian Portuguese
------------------------------------------------------------------------

if CURRENT_LOCALE == "ptBR" then

L.NOTES = "Mudar as cores de classes sem quebrar a interface do usuário da Blizzard."
L.NOTES_DESC = "Note que nem todos os addons aprovar isso, e você pode ter que recarregar a interface antes de suas alterações são reconhecidos por todos os addons compatíveis."
L.RESET_DESC = "Redefinir todas as cores de classes para o padrão."

return end

------------------------------------------------------------------------
-- Russian
------------------------------------------------------------------------

if CURRENT_LOCALE == "ruRU" then

L.NOTES = "Изменение цветов класса не вмешиваясь в Blizzard UI"
L.NOTES_DESC = "Обратите внимание, что не все аддоны поддерживают это, и возможно вам потребуется перезагрузить интерфейс, прежде чем изменения вступят в силу на всех совместимых аддонах. "
L.RESET_DESC = "Сбросить окраску классов на значение по умолчанию."

return end

------------------------------------------------------------------------
-- Korean
------------------------------------------------------------------------

if CURRENT_LOCALE == "koKR" then

L.NOTES = "블리자드 UI를 변경하지 않고 클래스의 색상을 변경합니다."
L.NOTES_DESC = "모든 애드온이이 기능을 지원합니다, 변경 사항이 애드온에 의해 인식되기 전에 UI를 다시 로드해야 할 수 있습니다."
L.RESET_DESC = "직업 색상을 기본값으로 되돌립니다."

return end

------------------------------------------------------------------------
-- Simplified Chinese
------------------------------------------------------------------------

if CURRENT_LOCALE == "zhCN" then

L.NOTES = "改变职业颜色不会破坏暴雪的界面."
L.NOTES_DESC = "请注意, 不是所有插件都支持这个功能, 而且可能需要重载界面才能使兼容的插件识别出你做的更改 ."
L.RESET_DESC = "重置职业颜色为默认。"

return end

------------------------------------------------------------------------
-- Traditional Chinese
------------------------------------------------------------------------

if CURRENT_LOCALE == "zhTW" then

L.RESET_DESC = "重置職業顔色為默認"

return end
